// Topic 1: Access specifiers with public inheritance

#include <stdio.h>

class Base
{
	public:
		void A() { printf("A\n"); }

	protected:
		void B() { printf("B\n"); }

	private:
		void C() { printf("C\n"); }
};

class Child : public Base
{
	public:
		void Foo()
		{
			A(); // Call Base::A()
			B(); // Call Base::B()
		/*	C(); // CANNOT CALL THIS! */
		}

	private:
		void A() 
		{ 
			Base::A(); 
		}
};

void main()
{
	Base base;
	base.A();	// Good!
/*	base.
	B();	// No good! */
/*	base.C();	// No good! */

	Child child;
	child.A();	// Good!
/*	child.B();	// No good! */
/*	child.C();	// No good! */

	child.Foo();
}
